/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	FirePit
**
** DESCRIPTION:	Fire pit puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef FIREPIT_H
#define FIREPIT_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "PuzzleInterface.h"
#include "Puzzle.h"
#include "../Collectables/CollectableInterface.h"
#include "../Game/GameTimer.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int FirePit_c_iBurnTime            = 20 * 60 * 60;

#if _DEBUG
const int FirePit_c_iWaterNeedForCooling   = 4;
const int FirePit_c_iWaterNeededForFireOut = 2;
#else
const int FirePit_c_iWaterNeedForCooling   = 12;
const int FirePit_c_iWaterNeededForFireOut = 4;
#endif
const int FirePit_c_iTimeToCompleteCooling = 10 * 60;

const ldwPoint FirePit_c_sCenter(901, 1032);

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CFirePit : public IPuzzle, public ICollectable
{
	friend class CPuzzle;

private:

	//class structures
	struct SSaveState
	{
		bool			m_bContainsKindling;
		bool			m_bContainsFirewood;
		unsigned int	m_uiBurnOutTime;
		unsigned int    m_uiFireCooledTime;
		int				m_iTotalBurnTime;
		int				m_iWaterDumpedCount;
	};

	//class data
	bool			m_bContainsKindling;
	bool			m_bContainsFirewood;
	CGameTimer		m_BurnOutTimer;
	CGameTimer      m_FireCooledTimer;
	int				m_iTotalBurnTime;
	int				m_iWaterDumpedCount;

	int				m_iSmoke;

	ldwImageGrid *	m_pFirewood;
	ldwImageGrid *	m_pKindling;

	//class methods
	//setup
	public:		CFirePit(void);
	public:		void Reset();
	public:		void ResetFire();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Refresh();
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Update();
	public:		void Advance(CVillager &Villager, const int iRef);
	public:		void Complete();

	public:		const bool Carry(CVillager &Villager, const ECarrying eCarrying);
	public:		void Drop(CVillager &Villager, const ECarrying eCarrying);

	public:		void LightFire();
	public:		void ExtinguishFire();
	public:		void Poof();

	// access
	public:		const ECarrying GetNearbyCollectable(CVillager &Villager, const ldwPoint sPos);
	public:		const bool ContainsKindling() const { return m_bContainsKindling; }
	public:		const bool ContainsFirewood() const { return m_bContainsFirewood; }
	public:		const bool IsLit() const;
	public:		const int SecondsRemainingOnFire() const;
	public:		const int TotalBurnTime() const;
	public:		const bool IsCooling() const;
	public:		const bool HasCooled() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CFirePit		FirePit;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/